package yangtz.cs.liu.campus.mapper.schoolStudio;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;
import yangtz.cs.liu.campus.domain.schoolStudio.SchoolStudioUse;

import java.util.List;

/**
 * 录播室使用情况Mapper接口
 *
 * @author ruoyi
 * @date 2023-07-10
 */
@Repository
public interface SchoolStudioUseMapper
{

    /**
     * 根据预约id删除录播室使用情况
     * @return
     */
    public int deleteSchoolStudioUseByAppId(@Param("appId") Long appId);

    /**
     * 录播室使用情况统计
     * @param schoolStudioUse
     * @return
     */
    public List<SchoolStudioUse> selectStudioUse(SchoolStudioUse schoolStudioUse);













    /**
     * 查询录播室使用情况
     *
     * @param id 录播室使用情况主键
     * @return 录播室使用情况
     */
    public SchoolStudioUse selectSchoolStudioUseById(Long id);

    /**
     * 查询录播室使用情况列表
     *
     * @param schoolStudioUse 录播室使用情况
     * @return 录播室使用情况集合
     */
    public List<SchoolStudioUse> selectSchoolStudioUseList(SchoolStudioUse schoolStudioUse);

    /**
     * 新增录播室使用情况
     *
     * @param schoolStudioUse 录播室使用情况
     * @return 结果
     */
    public int insertSchoolStudioUse(SchoolStudioUse schoolStudioUse);

    /**
     * 修改录播室使用情况
     *
     * @param schoolStudioUse 录播室使用情况
     * @return 结果
     */
    public int updateSchoolStudioUse(SchoolStudioUse schoolStudioUse);

    /**
     * 删除录播室使用情况
     *
     * @param id 录播室使用情况主键
     * @return 结果
     */
    public int deleteSchoolStudioUseById(Long id);

    /**
     * 批量删除录播室使用情况
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolStudioUseByIds(Long[] ids);


}
