package yangtz.cs.liu.campus.mapper.schoolStudio;

import org.springframework.stereotype.Repository;
import yangtz.cs.liu.campus.domain.schoolStudio.SchoolStudioAppointment;

import java.util.List;

/**
 * 录播室预约情况Mapper接口
 *
 * @author ruoyi
 * @date 2023-07-10
 */
@Repository
public interface SchoolStudioAppointmentMapper
{
    /**
     * 查询录播室预约情况
     *
     * @param id 录播室预约情况主键
     * @return 录播室预约情况
     */
    public SchoolStudioAppointment selectSchoolStudioAppointmentById(Long id);

    /**
     * 查询录播室预约情况列表
     *
     * @param schoolStudioAppointment 录播室预约情况
     * @return 录播室预约情况集合
     */
    public List<SchoolStudioAppointment> selectSchoolStudioAppointmentList(SchoolStudioAppointment schoolStudioAppointment);

    /**
     * 新增录播室预约情况
     *
     * @param schoolStudioAppointment 录播室预约情况
     * @return 结果
     */
    public int insertSchoolStudioAppointment(SchoolStudioAppointment schoolStudioAppointment);

    /**
     * 修改录播室预约情况
     *
     * @param schoolStudioAppointment 录播室预约情况
     * @return 结果
     */
    public int updateSchoolStudioAppointment(SchoolStudioAppointment schoolStudioAppointment);

    /**
     * 删除录播室预约情况
     *
     * @param id 录播室预约情况主键
     * @return 结果
     */
    public int deleteSchoolStudioAppointmentById(Long id);

    /**
     * 批量删除录播室预约情况
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolStudioAppointmentByIds(Long[] ids);
}
