package yangtz.cs.liu.campus.mapper.schoolSecurity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVehicleRegistration;

import java.util.List;

/**
 * 车辆登记Mapper接口
 *
 * @author ruoyi
 * @date 2023-09-11
 */
public interface SchoolVehicleRegistrationMapper extends BaseMapper<SchoolVehicleRegistration>
{

    /**
     * 查询车辆登记
     *
     * @param id 车辆登记主键
     * @return 车辆登记
     */
    public SchoolVehicleRegistration selectSchoolVehicleRegistrationById(Long id);

    /**
     * 查询车辆登记列表
     *
     * @param schoolVehicleRegistration 车辆登记
     * @return 车辆登记集合
     */
    public List<SchoolVehicleRegistration> selectSchoolVehicleRegistrationList(SchoolVehicleRegistration schoolVehicleRegistration);

    /**
     * 新增车辆登记
     *
     * @param schoolVehicleRegistration 车辆登记
     * @return 结果
     */
    public int insertSchoolVehicleRegistration(SchoolVehicleRegistration schoolVehicleRegistration);

    /**
     * 修改车辆登记
     *
     * @param schoolVehicleRegistration 车辆登记
     * @return 结果
     */
    public int updateSchoolVehicleRegistration(SchoolVehicleRegistration schoolVehicleRegistration);

    /**
     * 删除车辆登记
     *
     * @param id 车辆登记主键
     * @return 结果
     */
    public int deleteSchoolVehicleRegistrationById(Long id);

    /**
     * 批量删除车辆登记
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolVehicleRegistrationByIds(Long[] ids);
}
