package yangtz.cs.liu.campus.mapper.schoolRewardsPunishments;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolRewardsPunishments.SchoolScDiscipline;
import yangtz.cs.liu.campus.vo.schoolRewardsPunishments.SchoolScDisciplineVo;

import java.util.List;
import java.util.Map;

/**
 * 学生违纪Mapper接口
 *
 * @author ruoyi
 * @date 2023-11-06
 */
public interface SchoolScDisciplineMapper extends BaseMapper<SchoolScDiscipline>
{
    /**
     * 查询学生违纪
     *
     * @param id 学生违纪主键
     * @return 学生违纪
     */
    public SchoolScDiscipline selectSchoolScDisciplineById(Long id);

    /**
     * 查询学生违纪列表
     *
     * @param schoolScDiscipline 学生违纪
     * @return 学生违纪集合
     */
    public List<SchoolScDiscipline> selectSchoolScDisciplineList(SchoolScDiscipline schoolScDiscipline);

    /**
     * 查询学生违纪列表(查看已通过)
     *
     * @param schoolScDiscipline 学生违纪
     * @return 学生违纪集合
     */
    List<SchoolScDiscipline> selectSchoolScDisciplineListTg(SchoolScDiscipline schoolScDiscipline);

    /**
     * 新增学生违纪
     *
     * @param schoolScDisciplineVo 学生违纪
     * @return 结果
     */
    public int insertSchoolScDiscipline(SchoolScDisciplineVo schoolScDisciplineVo);

    /**
     * 修改学生违纪
     *
     * @param schoolScDisciplineVo 学生违纪
     * @return 结果
     */
    public int updateSchoolScDiscipline(SchoolScDisciplineVo schoolScDisciplineVo);

    /**
     * 删除学生违纪
     *
     * @param id 学生违纪主键
     * @return 结果
     */
    public int deleteSchoolScDisciplineById(Long id);

    /**
     * 批量删除学生违纪
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolScDisciplineByIds(Long[] ids);

    /**
     * 获取最新三个年级
     * @return
     */
    List<Map<String, Object>> getGrade();

    /**
     * 根据年级获取班级
     * @param gradeId
     * @return
     */
    List<Map<String, Object>> getClassList(Long gradeId);

    /**
     * 新增学生违纪附件
     * @param list
     */
    int batchSchoolAccessory(List<SchoolAccessory> list);

    /**
     * 批量删除学生违纪附件
     * @param ids
     */
    void deleteSchoolAccessoryByBusinessIds(Long[] ids);

    /**
     * 删除学生违纪附件
     * @param id
     */
    void deleteSchoolAccessoryByBusinessId(Long id);
}
