package yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolGkAchievement;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteamAward;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteamAwardVo;

import java.util.List;

/**
 * 团队获奖Mapper接口
 *
 * @author ruoyi
 * @date 2023-12-13
 */
public interface SchoolXteamAwardMapper  extends BaseMapper<SchoolXteamAward>
{
    /**
     * 查询团队获奖
     *
     * @param id 团队获奖主键
     * @return 团队获奖
     */
    public SchoolXteamAward selectSchoolXteamAwardById(Long id);

    /**
     * 查询团队获奖列表
     *
     * @param schoolXteamAwardVo 团队获奖
     * @return 团队获奖集合
     */
    public List<SchoolXteamAward> selectSchoolXteamAwardList(SchoolXteamAwardVo schoolXteamAwardVo);
    public List<SchoolXteamAwardVo> selectSchoolXteamAwardVoList(SchoolXteamAwardVo schoolXteamAwardVo);

    /**
     * 新增团队获奖
     *
     * @param schoolXteamAward 团队获奖
     * @return 结果
     */
    public int insertSchoolXteamAward(SchoolXteamAward schoolXteamAward);

    /**
     * 修改团队获奖
     *
     * @param schoolXteamAward 团队获奖
     * @return 结果
     */
    public int updateSchoolXteamAward(SchoolXteamAward schoolXteamAward);

    /**
     * 删除团队获奖
     *
     * @param id 团队获奖主键
     * @return 结果
     */
    public int deleteSchoolXteamAwardById(Long id);

    /**
     * 批量删除团队获奖
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolXteamAwardByIds(Long[] ids);
}
