package yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteachingAchievements;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXteachingAchievementsVo;

import java.util.List;
import java.util.Map;

/**
 * 教学成绩Mapper接口
 *
 * @author ruoyi
 * @date 2023-12-06
 */
public interface SchoolXteachingAchievementsMapper extends BaseMapper<SchoolXteachingAchievements>
{
    /**
     * 查询教学成绩
     *
     * @param id 教学成绩主键
     * @return 教学成绩
     */
    public SchoolXteachingAchievementsVo selectSchoolXteachingAchievementsById(Long id);

    /**
     * 查询教学成绩列表
     *
     * @param schoolXteachingAchievementsVo 教学成绩
     * @return 教学成绩集合
     */
    public List<SchoolXteachingAchievementsVo> selectSchoolXteachingAchievementsList(SchoolXteachingAchievementsVo schoolXteachingAchievementsVo);

    /**
     * 新增教学成绩
     *
     * @param schoolXteachingAchievements 教学成绩
     * @return 结果
     */
    public int insertSchoolXteachingAchievements(SchoolXteachingAchievements schoolXteachingAchievements);

    /**
     * 修改教学成绩
     *
     * @param schoolXteachingAchievements 教学成绩
     * @return 结果
     */
    public int updateSchoolXteachingAchievements(SchoolXteachingAchievements schoolXteachingAchievements);

    /**
     * 删除教学成绩
     *
     * @param id 教学成绩主键
     * @return 结果
     */
    public int deleteSchoolXteachingAchievementsById(Long id);

    /**
     * 批量删除教学成绩
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolXteachingAchievementsByIds(Long[] ids);

    List<Map<String, Object>> getUserList(SysUser sysUser);

    /**
     * 查询本部门下所有教师id
     * @param deptId
     * @return
     */
    List<Long> getUserIdsByDeptId(@Param("deptId") Long deptId);

    /**
     * 查询本部门下所有教师手机号
     * @param deptId
     * @return
     */
    List<String> getUserPhonesByDeptId(@Param("deptId") Long deptId);

    /**
     * 查询所有级部id
     * @return
     */
    List<Long> getJbDeptId();

    /**
     * 查询所有科室id
     * @return
     */
    List<Long> getKsDeptId();

}
