package yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn;


import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteacherAwards;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXteacherAwardsVo;

import java.util.List;

/**
 * 教师获奖Mapper接口
 *
 * @author ruoyi
 * @date 2023-12-06
 */
public interface SchoolXteacherAwardsMapper
{
    /**
     * 查询教师获奖
     *
     * @param id 教师获奖主键
     * @return 教师获奖
     */
    public SchoolXteacherAwardsVo selectSchoolXteacherAwardsById(Long id);

    /**
     * 查询教师获奖列表
     *
     * @param schoolXteacherAwardsVo 教师获奖
     * @return 教师获奖集合
     */
    public List<SchoolXteacherAwardsVo> selectSchoolXteacherAwardsList(SchoolXteacherAwardsVo schoolXteacherAwardsVo);

    /**
     * 新增教师获奖
     *
     * @param schoolXteacherAwards 教师获奖
     * @return 结果
     */
    public int insertSchoolXteacherAwards(SchoolXteacherAwards schoolXteacherAwards);

    /**
     * 修改教师获奖
     *
     * @param schoolXteacherAwards 教师获奖
     * @return 结果
     */
    public int updateSchoolXteacherAwards(SchoolXteacherAwards schoolXteacherAwards);

    /**
     * 删除教师获奖
     *
     * @param id 教师获奖主键
     * @return 结果
     */
    public int deleteSchoolXteacherAwardsById(Long id);

    /**
     * 批量删除教师获奖
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolXteacherAwardsByIds(Long[] ids);
}
