package yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXsyouthTeacher;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXsyouthTeacherVo;

/**
 * 青年教师成长档案Mapper接口
 *
 * @author ruoyi
 * @date 2024-01-29
 */
public interface SchoolXsyouthTeacherMapper extends BaseMapper<SchoolXsyouthTeacher>
{
    /**
     * 查询青年教师成长档案
     *
     * @param id 青年教师成长档案主键
     * @return 青年教师成长档案
     */
    public SchoolXsyouthTeacher selectSchoolXsyouthTeacherById(Long id);

    /**
     * 查询青年教师成长档案列表
     *
     * @param schoolXsyouthTeacherVo 青年教师成长档案
     * @return 青年教师成长档案集合
     */
    public List<SchoolXsyouthTeacher> selectSchoolXsyouthTeacherList(SchoolXsyouthTeacherVo schoolXsyouthTeacherVo);

    /**
     * 新增青年教师成长档案
     *
     * @param schoolXsyouthTeacher 青年教师成长档案
     * @return 结果
     */
    public int insertSchoolXsyouthTeacher(SchoolXsyouthTeacher schoolXsyouthTeacher);

    /**
     * 修改青年教师成长档案
     *
     * @param schoolXsyouthTeacher 青年教师成长档案
     * @return 结果
     */
    public int updateSchoolXsyouthTeacher(SchoolXsyouthTeacher schoolXsyouthTeacher);

    /**
     * 删除青年教师成长档案
     *
     * @param id 青年教师成长档案主键
     * @return 结果
     */
    public int deleteSchoolXsyouthTeacherById(Long id);

    /**
     * 批量删除青年教师成长档案
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolXsyouthTeacherByIds(Long[] ids);
}
