package yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXprojectResearch;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXprojectResearchVo;

import java.util.List;

/**
 * 课题研究Mapper接口
 *
 * @author ruoyi
 * @date 2023-12-13
 */
public interface SchoolXprojectResearchMapper extends BaseMapper<SchoolXprojectResearch> {

    /**
     * 查询课题研究
     *
     * @param id 课题研究主键
     * @return 课题研究
     */
    public SchoolXprojectResearchVo selectSchoolXprojectResearchById(Long id);

    /**
     * 查询课题研究列表
     *
     * @param schoolXprojectResearchVo 课题研究
     * @return 课题研究集合
     */
    public List<SchoolXprojectResearchVo> selectSchoolXprojectResearchList(SchoolXprojectResearchVo schoolXprojectResearchVo);

    /**
     * 新增课题研究
     *
     * @param schoolXprojectResearch 课题研究
     * @return 结果
     */
    public int insertSchoolXprojectResearch(SchoolXprojectResearch schoolXprojectResearch);

    /**
     * 修改课题研究
     *
     * @param schoolXprojectResearch 课题研究
     * @return 结果
     */
    public int updateSchoolXprojectResearch(SchoolXprojectResearch schoolXprojectResearch);

    /**
     * 删除课题研究
     *
     * @param id 课题研究主键
     * @return 结果
     */
    public int deleteSchoolXprojectResearchById(Long id);

    /**
     * 批量删除课题研究
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolXprojectResearchByIds(Long[] ids);
}
