package yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolGkAchievement;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolGkAchievementVo;

import java.util.List;

/**
 * 高考成绩Mapper接口
 *
 * @author ruoyi
 * @date 2023-12-13
 */
public interface SchoolGkAchievementMapper   extends BaseMapper<SchoolGkAchievement>
{
    /**
     * 查询高考成绩
     *
     * @param id 高考成绩主键
     * @return 高考成绩
     */
    public SchoolGkAchievement selectSchoolGkAchievementById(Long id);

    /**
     * 查询高考成绩列表
     *
     * @param schoolGkAchievementVo 高考成绩
     * @return 高考成绩集合
     */
    public List<SchoolGkAchievementVo> selectSchoolGkAchievementVoList(SchoolGkAchievementVo schoolGkAchievementVo);
    public List<SchoolGkAchievement> selectSchoolGkAchievementList(SchoolGkAchievementVo schoolGkAchievementVo);

    /**
     * 新增高考成绩
     *
     * @param schoolGkAchievement 高考成绩
     * @return 结果
     */
    public int insertSchoolGkAchievement(SchoolGkAchievement schoolGkAchievement);

    /**
     * 修改高考成绩
     *
     * @param schoolGkAchievement 高考成绩
     * @return 结果
     */
    public int updateSchoolGkAchievement(SchoolGkAchievement schoolGkAchievement);

    /**
     * 删除高考成绩
     *
     * @param id 高考成绩主键
     * @return 结果
     */
    public int deleteSchoolGkAchievementById(Long id);

    /**
     * 批量删除高考成绩
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolGkAchievementByIds(Long[] ids);
}
