package yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAworkload;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAworkloadExport;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAworkloadVo;

import java.util.List;

/**
 * 工作量信息Mapper接口
 *
 * @author ruoyi
 * @date 2023-12-11
 */
public interface SchoolAworkloadMapper  extends BaseMapper<SchoolAworkload>
{
    /**
     * 查询工作量信息
     *
     * @param id 工作量信息主键
     * @return 工作量信息
     */
    public SchoolAworkload selectSchoolAworkloadById(Long id);

    /**
     * 查询工作量信息列表
     *
     * @param schoolAworkloadVo 工作量信息
     * @return 工作量信息集合
     */
    public List<SchoolAworkloadVo> selectSchoolAworkloadList(SchoolAworkloadVo schoolAworkloadVo);

    public List<SchoolAworkloadExport> selectAworkloadList(SchoolAworkloadVo schoolAworkloadVo);

    /**
     * 新增工作量信息
     *
     * @param schoolAworkload 工作量信息
     * @return 结果
     */
    public int insertSchoolAworkload(SchoolAworkload schoolAworkload);

    /**
     * 修改工作量信息
     *
     * @param schoolAworkload 工作量信息
     * @return 结果
     */
    public int updateSchoolAworkload(SchoolAworkload schoolAworkload);

    /**
     * 删除工作量信息
     *
     * @param id 工作量信息主键
     * @return 结果
     */
    public int deleteSchoolAworkloadById(Long id);

    /**
     * 批量删除工作量信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolAworkloadByIds(Long[] ids);
}
