package yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAclassTeacherAssessment;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAclassTeacherAssessmentReq;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAclassTeacherAssessmentVo;

import java.util.List;

/**
 * 班主任考核Mapper接口
 * 
 * @author ruoyi
 * @date 2023-12-12
 */
public interface SchoolAclassTeacherAssessmentMapper extends BaseMapper<SchoolAclassTeacherAssessment>
{
    /**
     * 查询班主任考核
     * 
     * @param id 班主任考核主键
     * @return 班主任考核
     */
    public SchoolAclassTeacherAssessment selectSchoolAclassTeacherAssessmentById(Long id);

    /**
     * 查询班主任考核列表
     * 
     * @param schoolAclassTeacherAssessment 班主任考核
     * @return 班主任考核集合
     */
    public List<SchoolAclassTeacherAssessmentVo> selectSchoolAclassTeacherAssessmentList(SchoolAclassTeacherAssessmentReq req);


    public List<SchoolAclassTeacherAssessment> selectSchoolList(SchoolAclassTeacherAssessmentReq req);

    /**
     * 新增班主任考核
     * 
     * @param schoolAclassTeacherAssessment 班主任考核
     * @return 结果
     */
    public int insertSchoolAclassTeacherAssessment(SchoolAclassTeacherAssessment schoolAclassTeacherAssessment);

    /**
     * 修改班主任考核
     * 
     * @param schoolAclassTeacherAssessment 班主任考核
     * @return 结果
     */
    public int updateSchoolAclassTeacherAssessment(SchoolAclassTeacherAssessment schoolAclassTeacherAssessment);

    /**
     * 删除班主任考核
     * 
     * @param id 班主任考核主键
     * @return 结果
     */
    public int deleteSchoolAclassTeacherAssessmentById(Long id);

    /**
     * 批量删除班主任考核
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolAclassTeacherAssessmentByIds(Long[] ids);
}
