package yangtz.cs.liu.campus.mapper.schoolLab;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYear;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYearRelation;
import yangtz.cs.liu.campus.vo.schoolLab.ClassSituationVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;

import java.util.List;

/**
 * 年级实验室预约Mapper接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface SchoolLabClassYearMapper extends BaseMapper<SchoolLabClassYear>
{

    /**
     * 查询年级实验室预约
     *
     * @param id 年级实验室预约主键
     * @return 年级实验室预约
     */
    public SchoolLabClassYearVo selectSchoolLabClassYearById(Long id);

    /**
     * 查询年级实验室预约列表
     *
     * @param schoolLabClassYearVo 年级实验室预约
     * @return 年级实验室预约集合
     */
    public List<SchoolLabClassYearVo> selectSchoolLabClassYearList(SchoolLabClassYearVo schoolLabClassYearVo);

    /**
     * 查询年级实验室预约列表(管理员)
     *
     * @param schoolLabClassYearVo 年级实验室预约
     * @return 年级实验室预约集合
     */
    public List<SchoolLabClassYearVo> selectLabClassYearListAdmin(SchoolLabClassYearVo schoolLabClassYearVo);

    /**
     * 新增年级实验室预约
     *
     * @param schoolLabClassYear 年级实验室预约
     * @return 结果
     */
    public int insertSchoolLabClassYear(SchoolLabClassYear schoolLabClassYear);

    /**
     * 修改年级实验室预约
     *
     * @param schoolLabClassYear 年级实验室预约
     * @return 结果
     */
    public int updateSchoolLabClassYear(SchoolLabClassYear schoolLabClassYear);

    /**
     * 删除年级实验室预约
     *
     * @param id 年级实验室预约主键
     * @return 结果
     */
    public int deleteSchoolLabClassYearById(Long id);

    /**
     * 批量删除年级实验室预约
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolLabClassYearByIds(Long[] ids);

    /**
     * 批量删除年级实验室预约和实验室关系
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolLabClassYearRelationByLabClassYearIds(Long[] ids);

    /**
     * 批量新增年级实验室预约和实验室关系
     *
     * @param schoolLabClassYearRelationList 年级实验室预约和实验室关系列表
     * @return 结果
     */
    public int batchSchoolLabClassYearRelation(List<SchoolLabClassYearRelation> schoolLabClassYearRelationList);


    /**
     * 通过年级实验室预约主键删除年级实验室预约和实验室关系信息
     *
     * @param id 年级实验室预约ID
     * @return 结果
     */
    public int deleteSchoolLabClassYearRelationByLabClassYearId(Long id);

    /**
     * 实验室管理-年级实验室预约列表
     * @param schoolLabClassYearVo
     * @return
     */
    List<SchoolLabClassYearVo> getLabClassYear(SchoolLabClassYearVo schoolLabClassYearVo);

    /**
     * 获取实验室id
     * @param labClassYearIds
     * @return
     */
    List<Long> seletLabId(@Param("labClassYearIds") List<Long> labClassYearIds);

    /**
     * 获取实验室id
     * @param teacherExperimentIds
     * @return
     */
    List<Long> seletLabIds(@Param("teacherExperimentIds") List<Long> teacherExperimentIds);

    /**
     * 实验室管理-年级实验室预约查看详情
     * @param id
     * @return
     */
    SchoolLabClassYearVo getLabClassYearById(Long id);

    /**
     * 教师-实验室安排列表
     * @param schoolLabClassYearVo
     * @return
     */
    List<SchoolLabClassYearVo> getTeacherLabList(SchoolLabClassYearVo schoolLabClassYearVo);

    /**
     * 获取年级 班级完成情况信息
     * @param
     * @return
     */
    public List<ClassSituationVo> classSituation(ClassSituationVo classSituationVo);

    public List<ClassSituationVo> getexperimentList(ClassSituationVo classSituationVo);
}
