package yangtz.cs.liu.campus.mapper.schoolInstrument;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolTeacherBorrow;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolTeacherBorrowDetail;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolTeacherBorrowVo;

import java.util.List;

/**
 * 教师借用Mapper接口
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@Repository
public interface SchoolTeacherBorrowMapper extends BaseMapper<SchoolTeacherBorrow> {

    /**
     * 查询教师借用
     *
     * @param id 教师借用主键
     * @return 教师借用
     */
    public SchoolTeacherBorrowVo selectSchoolTeacherBorrowById(Long id);

    /**
     * 查询教师借用列表
     *
     * @param schoolTeacherBorrowVo 教师借用
     * @return 教师借用集合
     */
    public List<SchoolTeacherBorrowVo> selectSchoolTeacherBorrowList(SchoolTeacherBorrowVo schoolTeacherBorrowVo);

    /**
     * 新增教师借用
     *
     * @param schoolTeacherBorrowVo 教师借用
     * @return 结果
     */
    public int insertSchoolTeacherBorrow(SchoolTeacherBorrowVo schoolTeacherBorrowVo);

    /**
     * 修改教师借用
     *
     * @param schoolTeacherBorrowVo 教师借用
     * @return 结果
     */
    public int updateSchoolTeacherBorrow(SchoolTeacherBorrowVo schoolTeacherBorrowVo);

    /**
     * 删除教师借用
     *
     * @param id 教师借用主键
     * @return 结果
     */
    public int deleteSchoolTeacherBorrowById(Long id);

    /**
     * 批量删除教师借用
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolTeacherBorrowByIds(Long[] ids);

    /**
     * 批量删除教师借用明细
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolTeacherBorrowDetailByTeacherBorrowIds(Long[] ids);

    /**
     * 批量新增教师借用明细
     *
     * @param schoolTeacherBorrowDetailList 教师借用明细列表
     * @return 结果
     */
    public int batchSchoolTeacherBorrowDetail(List<SchoolTeacherBorrowDetail> schoolTeacherBorrowDetailList);


    /**
     * 通过教师借用主键删除教师借用明细信息
     *
     * @param id 教师借用ID
     * @return 结果
     */
    public int deleteSchoolTeacherBorrowDetailByTeacherBorrowId(Long id);

    /**
     * 批量修改归还教师借用明细
     * @param list
     * @return
     */
    int updateSchoolTeacherBorrowDetails(@Param("list") List<SchoolTeacherBorrowDetail> list);
}
