package yangtz.cs.liu.campus.mapper.schoolInstrument;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrumentDetail;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolInstrumentDetailVo;

import java.util.List;

/**
 * 仪器出入库明细Mapper接口
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@Repository
public interface SchoolInstrumentDetailMapper extends BaseMapper<SchoolInstrumentDetail> {

    /**
     * 查询仪器出入库明细
     *
     * @param id 仪器出入库明细主键
     * @return 仪器出入库明细
     */
    public SchoolInstrumentDetail selectSchoolInstrumentDetailById(Long id);

    /**
     * 查询仪器出入库明细列表
     *
     * @param schoolInstrumentDetailVo 仪器出入库明细
     * @return 仪器出入库明细集合
     */
    public List<SchoolInstrumentDetail> selectSchoolInstrumentDetailList(SchoolInstrumentDetailVo schoolInstrumentDetailVo);

    /**
     * 新增仪器出入库明细
     *
     * @param schoolInstrumentDetail 仪器出入库明细
     * @return 结果
     */
    public int insertSchoolInstrumentDetail(SchoolInstrumentDetail schoolInstrumentDetail);

    /**
     * 修改仪器出入库明细
     *
     * @param schoolInstrumentDetail 仪器出入库明细
     * @return 结果
     */
    public int updateSchoolInstrumentDetail(SchoolInstrumentDetail schoolInstrumentDetail);

    /**
     * 删除仪器出入库明细
     *
     * @param id 仪器出入库明细主键
     * @return 结果
     */
    public int deleteSchoolInstrumentDetailById(Long id);

    /**
     * 批量删除仪器出入库明细
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolInstrumentDetailByIds(Long[] ids);
}
