package yangtz.cs.liu.campus.mapper.schoolEquipment;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolProductCategory;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolProductCategoryVo;

import java.util.List;
import java.util.Map;

public interface ProductCategoryMapper extends BaseMapper<SchoolProductCategory> {

    /**
     * 查询产品分类列表
     * @param schoolProductCategory
     * @return
     */
    List<SchoolProductCategory> selectSchoolProductCateGory(SchoolProductCategory schoolProductCategory);

    /**
     * 查询产品分类详细信息
     * @param id
     * @return
     */
    SchoolProductCategoryVo selectSchoolProductCateGoryById(Long id);

    /**
     * 删除产品分类信息
     * @param id
     * @return
     */
    int deleteSchoolProductCategory(@Param("id") Long id);

    /**
     * 获取设备分类下拉框
     * @param
     * @return
     */
    List<Map<String, String>> getEquipmentType(SchoolProductCategory schoolProductCategory);

    /**
     * 获取管理员
     * @return
     */
    List<Map<String, String>> getAdmin(SchoolProductCategory schoolProductCategory);

    /**
     * 查询个人产品分类列表
     * @param schoolProductCategory
     * @return
     */
    List<SchoolProductCategory> selectSchoolProductCateGoryGr(SchoolProductCategory schoolProductCategory);
    List<SchoolProductCategory> selectProductCategoryList(SchoolProductCategory schoolProductCategory);

    /**
     * 获取个人设备分类下拉框
     * @param schoolProductCategory
     * @return
     */
    List<Map<String, String>> getEquipmentTypeGr(SchoolProductCategory schoolProductCategory);

    /**
     * 获取管理员
     * @param schoolProductCategory
     * @return
     */
    List<Map<String, String>> getAdminGr(SchoolProductCategory schoolProductCategory);
}
