package yangtz.cs.liu.campus.mapper.schoolEquipment;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentLedger;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolEquipmentLedgerVo;

import java.util.List;
import java.util.Map;

public interface EquipmentLedgerMapper extends BaseMapper<SchoolEquipmentLedger> {
    /**
     * 查看设备台账列表
     * @param schoolEquipmentLedgerVo
     * @return
     */
    List<SchoolEquipmentLedger> selectSchoolEquipmentLedgerList(SchoolEquipmentLedgerVo schoolEquipmentLedgerVo);

    /**
     * 批量出库设备信息
     * @param ids
     * @return
     */
    int outSchoolEquipmentLedger(Long[] ids);

    /**
     * 获取用户
     * @return
     */
    List<Map<String, Object>> getUser(SysUser sysUser);

    /**
     * 查看个人设备台账列表
     * @param schoolEquipmentLedgerVo
     * @return
     */
    List<SchoolEquipmentLedger> selectSchoolEquipmentLedgerListGr(SchoolEquipmentLedgerVo schoolEquipmentLedgerVo);

    /**
     * 打印设备条码信息
     * @param ids
     * @return
     */
    List<Map<String, Object>> getEquipmentledger(Long[] ids);
}
