package yangtz.cs.liu.campus.mapper.schoolDcwj;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjNr;
import yangtz.cs.liu.campus.vo.schoolDcwj.SchoolDcwjNrVo;

import java.util.List;

/**
 * 内容问题Mapper接口
 *
 * @author wengxiulin
 * @date 2023-02-27
 */
@Mapper
public interface SchoolDcwjNrMapper extends BaseMapper<SchoolDcwjNr>
{
    /**
     * 查询内容问题
     *
     * @param id 内容问题主键
     * @return 内容问题
     */
    public SchoolDcwjNr selectSchoolDcwjNrById(Long id);

    /**
     * 查询内容问题列表
     *
     * @param schoolDcwjNr 内容问题
     * @return 内容问题集合
     */
    public List<SchoolDcwjNr> selectSchoolDcwjNrList(SchoolDcwjNr schoolDcwjNr);

    /**
     * 新增内容问题
     *
     * @param schoolDcwjNr 内容问题
     * @return 结果
     */
    public int insertSchoolDcwjNr(SchoolDcwjNr schoolDcwjNr);

    /**
     * 修改内容问题
     *
     * @param schoolDcwjNr 内容问题
     * @return 结果
     */
    public int updateSchoolDcwjNr(SchoolDcwjNr schoolDcwjNr);

    /**
     * 删除内容问题
     *
     * @param id 内容问题主键
     * @return 结果
     */
    public int deleteSchoolDcwjNrById(Long id);

    /**
     * 批量删除内容问题
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolDcwjNrByIds(Long[] ids);

    /**
     * 新增或修改时，获取排序在本题之上的选择或多选题,即排讯号小于当前题目的排序
     * */
    List<SchoolDcwjNr> getSelectList(SchoolDcwjNr schoolDcwjNr);
}
