package yangtz.cs.liu.campus.mapper.schoolAnnualAssessment;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolAnnualAssessment.SchoolAnnualAssessment;
import yangtz.cs.liu.campus.vo.schoolAnnualAssessment.SchoolAnnualAssessmentVo;

import java.util.List;

/**
 * 年度考核Mapper接口
 *
 * @author ruoyi
 * @date 2023-12-05
 */
public interface SchoolAnnualAssessmentMapper extends BaseMapper<SchoolAnnualAssessment> {

    /**
     * 查询年度考核
     *
     * @param id 年度考核主键
     * @return 年度考核
     */
    public SchoolAnnualAssessment selectSchoolAnnualAssessmentById(Long id);

    /**
     * 查询年度考核列表
     *
     * @param schoolAnnualAssessmentVo 年度考核
     * @return 年度考核集合
     */
    public List<SchoolAnnualAssessment> selectSchoolAnnualAssessmentList(SchoolAnnualAssessmentVo schoolAnnualAssessmentVo);

    /**
     * 新增年度考核
     *
     * @param schoolAnnualAssessment 年度考核
     * @return 结果
     */
    public int insertSchoolAnnualAssessment(SchoolAnnualAssessment schoolAnnualAssessment);

    /**
     * 修改年度考核
     *
     * @param schoolAnnualAssessment 年度考核
     * @return 结果
     */
    public int updateSchoolAnnualAssessment(SchoolAnnualAssessment schoolAnnualAssessment);

    /**
     * 删除年度考核
     *
     * @param id 年度考核主键
     * @return 结果
     */
    public int deleteSchoolAnnualAssessmentById(Long id);

    /**
     * 批量删除年度考核
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolAnnualAssessmentByIds(Long[] ids);
}
