package yangtz.cs.liu.campus.mapper.recruit;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitStudent;
import yangtz.cs.liu.campus.vo.recruit.SchoolRecruitStudentExportVo;
import yangtz.cs.liu.webpage.vo.WebSchoolRecruitStudentVo;

/**
 * @author xuten
 */
@Mapper
public interface SchoolRecruitStudentMapper extends BaseMapper<SchoolRecruitStudent> {

    /**
     * 校验手机号码是否唯一
     */
    public SchoolRecruitStudent checkPhoneUnique(String phoneNumber);

    /**
     * 校验身份证号码是否唯一
     */
    public SchoolRecruitStudent checkIdCardUnique(String idCard);

    /**
     * 根据手机号查找艺考生信息
     * */
    public SchoolRecruitStudent getStudentByPhoneNumber(@Param("phoneNumber") String phoneNumber,
                                                    @Param("idCard") String idCard);

    /**获取考生信息详情*/
    WebSchoolRecruitStudentVo getInfo(Long id);

    /**
     * 获取考试考生详情
     * */
    WebSchoolRecruitStudentVo getStuInfo(@Param("id") Long id,
                                     @Param("examId") Long examId);

    /** 教务管理-考试管理-信息审核-导出报名信息  */
    List<SchoolRecruitStudentExportVo> editExport(@Param("idList") List<Long> idList,
                                        @Param("examId") Long examId);
}
