package yangtz.cs.liu.campus.mapper.recruit;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitRelation;
import yangtz.cs.liu.campus.vo.recruit.RecruitEduStudentVo;
import yangtz.cs.liu.campus.vo.recruit.RecruitExamAddressVo;
import yangtz.cs.liu.campus.vo.recruit.RecruitExamScoreVo;

import java.util.List;

@Mapper
public interface SchoolRecruitRelationMapper extends BaseMapper<SchoolRecruitRelation> {

    //通过考试id和考生id获取关系
    SchoolRecruitRelation getRelationByIds(@Param("examId") Long examId,
                                       @Param("studentId") Long studentId);

    /** 教务管理-考试管理-信息审核列表 */
    List<RecruitEduStudentVo> getInfoCheck(RecruitEduStudentVo vo);

    /**
     * 考试管理-考场分配-列表
     * */
    List<RecruitExamAddressVo> getAddressList(RecruitExamAddressVo vo);

    RecruitExamScoreVo getAddressInfo(Long id);

    /**
     * 考试管理-成绩管理-列表
     * */
    List<RecruitExamScoreVo> getScoreList(RecruitExamScoreVo vo);
}
