package yangtz.cs.liu.campus.mapper.material;

import java.util.List;
import yangtz.cs.liu.campus.domain.material.Material;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

/**
 * 课题、结题、专著、校本教材编写情况Mapper接口
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public interface MaterialMapper
{
    /**
     * 查询课题、结题、专著、校本教材编写情况
     *
     * @param id 课题、结题、专著、校本教材编写情况主键
     * @return 课题、结题、专著、校本教材编写情况
     */
    public Material selectMaterialById(Long id);

    /**
     * 查询课题、结题、专著、校本教材编写情况列表
     *
     * @param material 课题、结题、专著、校本教材编写情况
     * @return 课题、结题、专著、校本教材编写情况集合
     */
    public List<Material> selectMaterialList(Material material);

    /**
     * 新增课题、结题、专著、校本教材编写情况
     *
     * @param material 课题、结题、专著、校本教材编写情况
     * @return 结果
     */
    public int insertMaterial(Material material);

    /**
     * 修改课题、结题、专著、校本教材编写情况
     *
     * @param material 课题、结题、专著、校本教材编写情况
     * @return 结果
     */
    public int updateMaterial(Material material);

    /**
     * 删除课题、结题、专著、校本教材编写情况
     *
     * @param id 课题、结题、专著、校本教材编写情况主键
     * @return 结果
     */
    public int deleteMaterialById(Long id);

    /**
     * 批量删除课题、结题、专著、校本教材编写情况
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMaterialByIds(Long[] ids);

    /**
     * 批量删除附件信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessIds(Long[] ids);

    /**
     * 批量新增附件信息
     *
     * @param schoolAccessoryList 附件信息列表
     * @return 结果
     */
    public int batchSchoolAccessory(List<SchoolAccessory> schoolAccessoryList);


    /**
     * 通过课题、结题、专著、校本教材编写情况主键删除附件信息信息
     *
     * @param id 课题、结题、专著、校本教材编写情况ID
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessId(Long id);
}
