package yangtz.cs.liu.campus.mapper.exam;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.exam.ExamUser;
import yangtz.cs.liu.campus.vo.exam.ExamUserVo;

import java.util.List;

@Mapper
public interface ExamUserMapper extends BaseMapper<ExamUser> {
    /**
     * 查询列表
     * @param examUser
     * @return
     */
    List<ExamUserVo> select(ExamUserVo examUser);



    /**
     * 导出
     * @param id
     * @return
     */
    ExamUserVo exportById(Integer id);

    /**
     * 查出当前问卷下所有学员id
     */
    List<Long> selectAllUserIdByExamId(Long examId);

    /*
   新增列表查询
    */
    List<ExamUserVo> selectAddList(@Param("userIdList")List<Long> userIdList,@Param("user") ExamUserVo examUser);





    /**
     * 挂载到当前问卷范围内
     */
    int insertExamUsers(@Param("examUserList")List<ExamUser> examUserList);
}
