package yangtz.cs.liu.campus.mapper.epidemic;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.epidemic.EpidemicUser;
import yangtz.cs.liu.campus.domain.exam.ExamUser;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicUserVo;
import yangtz.cs.liu.campus.vo.exam.ExamUserVo;

import java.util.List;

@Mapper
public interface EpidemicUserMapper extends BaseMapper<EpidemicUser> {
    /**
     * 查询列表
     * @param epidemicUser
     * @return
     */
    List<EpidemicUserVo> select(EpidemicUserVo epidemicUser);



    /**
     * 导出
     * @param id
     * @return
     */
    EpidemicUserVo exportById(Integer id);

    /**
     * 查出当前问卷下所有学员id
     */
    List<Long> selectAllUserIdByExamId(Long examId);

    /*
   新增列表查询
    */
    List<EpidemicUserVo> selectAddList(@Param("userIdList")List<Long> userIdList,@Param("user") EpidemicUserVo epidemicUser);





    /**
     * 挂载到当前问卷范围内
     */
    int insertEpidemicUsers(@Param("examUserList")List<EpidemicUser> epidemicUserList);
}
