package yangtz.cs.liu.campus.mapper.curricula;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.curricula.CurriculaStudent;
import yangtz.cs.liu.campus.vo.curricula.CurriculaStudentVo;

import java.util.List;
import java.util.Map;

public interface CurriculaStudentMapper extends BaseMapper<CurriculaStudent> {

    /**
     * 统计总人数/已选课程人数
     * @param curriculaId
     * @return
     */
    Map<String,Long> countNum(@Param("curriculaId") Long curriculaId);

    /**
     * 查看选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    List<CurriculaStudentVo> selectCurriculaStudentList(CurriculaStudentVo curriculaStudentVo);

    /**
     * 查看选课情况列表(班主任)
     * @param curriculaStudentVo
     * @return
     */
    List<CurriculaStudentVo> selectCurriculaStudentListBzr(CurriculaStudentVo curriculaStudentVo);

    /**
     * 查看春季选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    List<CurriculaStudentVo> selectCurriculaStudentListCj(CurriculaStudentVo curriculaStudentVo);

    /**
     * 查看夏季选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    List<CurriculaStudentVo> selectCurriculaStudentListXj(CurriculaStudentVo curriculaStudentVo);

    /**
     * 查看夏季二次分班情况列表
     * @param curriculaStudentVo
     * @return
     */
    List<CurriculaStudentVo> selectCurriculaStudentListXjEc(CurriculaStudentVo curriculaStudentVo);

    /**
     * 查看艺体选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    List<CurriculaStudentVo> selectCurriculaStudentListYt(CurriculaStudentVo curriculaStudentVo);

    /**
     * 批量新增学生和选课关系
     * @param list
     * @return
     */
    int batchInsertCurriculaStudent(List<CurriculaStudent> list);
}
