package yangtz.cs.liu.campus.mapper.award;

import java.util.List;
import yangtz.cs.liu.campus.domain.award.Award;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

/**
 * 获奖情况Mapper接口
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public interface AwardMapper
{
    /**
     * 查询获奖情况
     *
     * @param id 获奖情况主键
     * @return 获奖情况
     */
    public Award selectAwardById(Long id);

    /**
     * 查询获奖情况列表
     *
     * @param award 获奖情况
     * @return 获奖情况集合
     */
    public List<Award> selectAwardList(Award award);

    /**
     * 新增获奖情况
     *
     * @param award 获奖情况
     * @return 结果
     */
    public int insertAward(Award award);

    /**
     * 修改获奖情况
     *
     * @param award 获奖情况
     * @return 结果
     */
    public int updateAward(Award award);

    /**
     * 删除获奖情况
     *
     * @param id 获奖情况主键
     * @return 结果
     */
    public int deleteAwardById(Long id);

    /**
     * 批量删除获奖情况
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteAwardByIds(Long[] ids);

    /**
     * 批量删除附件信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessIds(Long[] ids);

    /**
     * 批量新增附件信息
     *
     * @param schoolAccessoryList 附件信息列表
     * @return 结果
     */
    public int batchSchoolAccessory(List<SchoolAccessory> schoolAccessoryList);


    /**
     * 通过获奖情况主键删除附件信息信息
     *
     * @param id 获奖情况ID
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessId(Long id);
}
