package yangtz.cs.liu.campus.mapper.area;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.common.core.domain.entity.SysDept;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.area.SchoolArea;
import yangtz.cs.liu.campus.vo.area.AreaVO;

import java.util.List;


/**
 * 场地信息Mapper接口
 *
 * @author ruoyi
 * @date 2022-09-29
 */
@Mapper
public interface SchoolAreaMapper extends BaseMapper<SchoolArea>
{
    Long selectIdByName(String areaName);

    List<AreaVO> queryList(SchoolArea area);

    //是否存在场地子节点
    public int hasChildById(Long id);

    //获取详情
    AreaVO queryInfo(Long id);

    /**
     * 根据ID查询所有子场地
     */
    public List<SchoolArea> selectChildrenAreaById(Long id);

    /**
     * 修改子元素关系
     *
     * @param areas 子元素
     * @return 结果
     */
    public int updateAreaChildren(@Param("areas") List<SchoolArea> areas);


}
