package yangtz.cs.liu.campus.mapper.area;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.area.SchoolAreaDetail;
import yangtz.cs.liu.campus.vo.area.AreaDetailVo;

/**
 * 场地详情信息Mapper接口
 * 
 * @author ruoyi
 * @date 2022-09-29
 */
@Mapper
public interface SchoolAreaDetailMapper extends BaseMapper<SchoolAreaDetail>
{
    List<AreaDetailVo> queryList(SchoolAreaDetail  schoolAreaDetail);

    List<Integer> selecthomeList(String areaNo);

    List selectAreaNameList(String areaName);

    Long getGradeId(@Param("gradeValue") Integer gradeValue, @Param("classValue") Integer classValue);

    AreaDetailVo queryById(Long id);

    AreaDetailVo selectExportList(Long id);

    List<AreaDetailVo> selectListByAreaId(Long id);

    Integer selectGradeByName(String gradeName);

    Integer selectClassByName(String className);

    int insertSchoolAreaDetail(AreaDetailVo schoolAreaDetail);

}
