package yangtz.cs.liu.campus.domain.time;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * 学校安排
 */
@Data
public class SchoolSchedule extends OurBaseEntity {

    private static final long serialVersionUID = 1L;

    /** 年级 */
    @Excel(name = "年级(必填)")
    private Integer yearValue;

    /** 季节 */
    private Long season;

    /** 年级 */
    @Excel(name = "年级(必填)")
    private Integer gradeValue;
    /** 班级 */

    @Excel(name = "班级(必填)")
    private Integer classValue;


    @Excel(name = "学校时刻school_time的id")
    private Long schoolTimeId;

    /** shool_time_detail中的序号 */
    @Excel(name = "课时排序(必填)")
    private Integer timeSort;

    /** 课时 */
    @Excel(name = "课时")
    private String sortName;

    /** 开始时间 */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "开始时间", width = 30, dateFormat = "HH:mm")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "结束时间", width = 30, dateFormat = "HH:mm")
    private Date endTime;

    /** 课时时间 */
    @Excel(name = "课时时间")
    private String sortTimeAll;

    /** 周一 */
    private String monday;
    /** 周一 */
    private String mondayId;
    /** 周二 */
    private String tuesday;
    /** 周二 */
    private String tuesdayId;
    /** 周三 */
    private String wednesday;
    /** 周三 */
    private String wednesdayId;
    /** 周四 */
    private String thursday;
    /** 周四 */
    private String thursdayId;
    /** 周五 */
    private String friday;
    /** 周五 */
    private String fridayId;
    /** 周六 */
    private String saturday;
    /** 周六 */
    private String saturdayId;
    /** 周日 */
    private String sunday;
    /** 周日 */
    private String sundayId;
}
