package yangtz.cs.liu.campus.domain.teacherFiles;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

import java.util.Date;
import java.util.List;

/**
 * 教师档案论文情况对象 teacher_files_thesis
 * 
 * @author ruoyi
 * @date 2023-09-08
 */
public class TeacherFilesThesis extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 原id */
    @Excel(name = "原id")
    private Long tId;

    /** 档案id */
    @Excel(name = "档案id")
    private Long filesId;

    /** 论文名称 */
    @Excel(name = "论文名称")
    private String thesisName;

    /** 级别（1国家级，2省级，3市级） */
    @Excel(name = "级别", readConverterExp = "1=国家级，2省级，3市级")
    private String level;

    /** 等级（1一等奖，2二等奖，3三等奖） */
    @Excel(name = "等级", readConverterExp = "1=一等奖，2二等奖，3三等奖")
    private String grade;

    /** 发表时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "发表时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date publishTime;

    private List<SchoolAccessory> schoolAccessoryList ;

    public List<SchoolAccessory> getSchoolAccessoryList() {
        return schoolAccessoryList;
    }

    public void setSchoolAccessoryList(List<SchoolAccessory> schoolAccessoryList) {
        this.schoolAccessoryList = schoolAccessoryList;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void settId(Long tId) 
    {
        this.tId = tId;
    }

    public Long gettId() 
    {
        return tId;
    }
    public void setFilesId(Long filesId) 
    {
        this.filesId = filesId;
    }

    public Long getFilesId() 
    {
        return filesId;
    }
    public void setThesisName(String thesisName) 
    {
        this.thesisName = thesisName;
    }

    public String getThesisName() 
    {
        return thesisName;
    }
    public void setLevel(String level) 
    {
        this.level = level;
    }

    public String getLevel() 
    {
        return level;
    }
    public void setGrade(String grade) 
    {
        this.grade = grade;
    }

    public String getGrade() 
    {
        return grade;
    }
    public void setPublishTime(Date publishTime) 
    {
        this.publishTime = publishTime;
    }

    public Date getPublishTime() 
    {
        return publishTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("tId", gettId())
            .append("filesId", getFilesId())
            .append("thesisName", getThesisName())
            .append("level", getLevel())
            .append("grade", getGrade())
            .append("publishTime", getPublishTime())
            .toString();
    }
}
