package yangtz.cs.liu.campus.domain.teacherFiles;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * 教室档案通知对象 teacher_files_notice
 * 
 * @author ruoyi
 * @date 2023-09-05
 */
@Data
public class TeacherFilesNotice extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private String id;

    private Long fId;

    /** 范围 */
    @Excel(name = "范围")
    private String noticeRange;

    /** 学年 */
    @Excel(name = "学年")
    private String noticeYear;

    /** 学期 */
    @Excel(name = "学期")
    private String noticeSemester;

    /** 通知名称 */
    @Excel(name = "通知名称")
    private String noticeName;

    /** 状态
     *     @Excel(name = "状态 (1未发布 2已发布 7已结束)" )
     * */
    @Excel(name = "状态")
    private String noticeState;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 填写状态 (1未发布 2已发布 3已填写 4已提交 5已确认 9驳回)"
     */
    private String state;

    private String teacherId;


}
