package yangtz.cs.liu.campus.domain.teacherFiles;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

import java.util.Date;
import java.util.List;

/**
 * 教师档案获奖情况对象 teacher_files_award
 * 
 * @author ruoyi
 * @date 2023-09-08
 */
public class TeacherFilesAward extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 原id */
    @Excel(name = "原id")
    private Long tId;

    /** 教师id */
    @Excel(name = "教师id")
    private Long filesId;

    /** 获奖名称 */
    @Excel(name = "获奖名称")
    private String awardName;

    /** 获奖时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "获奖时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date awardTime;

    /** 获奖等级（1一等奖，2二等奖，3三等奖） */
    @Excel(name = "获奖等级", readConverterExp = "1=一等奖，2=二等奖，3=三等奖")
    private String gradeOfAward;

    /** 发证机关 */
    @Excel(name = "发证机关")
    private String licenseIssuingAuthority;

    private List<SchoolAccessory> accessories;

    public List<SchoolAccessory> getAccessories() {
        return accessories;
    }

    public void setAccessories(List<SchoolAccessory> accessories) {
        this.accessories = accessories;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void settId(Long tId) 
    {
        this.tId = tId;
    }

    public Long gettId() 
    {
        return tId;
    }
    public void setFilesId(Long filesId) 
    {
        this.filesId = filesId;
    }

    public Long getFilesId() 
    {
        return filesId;
    }
    public void setAwardName(String awardName) 
    {
        this.awardName = awardName;
    }

    public String getAwardName() 
    {
        return awardName;
    }
    public void setAwardTime(Date awardTime) 
    {
        this.awardTime = awardTime;
    }

    public Date getAwardTime() 
    {
        return awardTime;
    }
    public void setGradeOfAward(String gradeOfAward) 
    {
        this.gradeOfAward = gradeOfAward;
    }

    public String getGradeOfAward() 
    {
        return gradeOfAward;
    }
    public void setLicenseIssuingAuthority(String licenseIssuingAuthority) 
    {
        this.licenseIssuingAuthority = licenseIssuingAuthority;
    }

    public String getLicenseIssuingAuthority() 
    {
        return licenseIssuingAuthority;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("tId", gettId())
            .append("filesId", getFilesId())
            .append("awardName", getAwardName())
            .append("awardTime", getAwardTime())
            .append("gradeOfAward", getGradeOfAward())
            .append("licenseIssuingAuthority", getLicenseIssuingAuthority())
            .toString();
    }
}
