package yangtz.cs.liu.campus.domain.teacherFiles;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 教师档案对象 teacher_files
 * 
 * @author ruoyi
 * @date 2023-09-05
 */
@Data
public class TeacherFiles
{
    private static final long serialVersionUID = 1L;

    /** id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 通知id */
    @Excel(name = "通知id")
    private String noticeId;

    /** 档案学年学期 */
    @Excel(name = "档案学年学期")
    private String filesSemester;

    /** 老师id */
    @Excel(name = "老师id")
    private Long teacherId;

    /** 老师名称 */
    @Excel(name = "老师名称")
    private String teacherName;

    /** 级部id */
    @Excel(name = "级部id")
    private Long gradeId;

    /** 级部名称 */
    @Excel(name = "级部名称")
    private String gradeName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 0男1女 */
    @Excel(name = "0男1女")
    private String sex;

    /** 年龄 */
    @Excel(name = "年龄")
    private Integer age;

    /** 职称 */
    @Excel(name = "职称")
    private String title;

    /** 学历 */
    @Excel(name = "学历")
    private String education;

    /** 政治面貌 */
    @Excel(name = "政治面貌")
    private String appearance;

    /** 任教学课 */
    @Excel(name = "任教学课")
    private String courseName;

    /** 任教班级 */
    @Excel(name = "任教班级")
    private String className;

    /** 任正班主任班级 */
    @Excel(name = "任正班主任班级")
    private String bzrClassName;

    /** 任副班主任班级 */
    @Excel(name = "任副班主任班级")
    private String fbzrClassName;

    /** 是否教学组长 */
    @Excel(name = "是否教学组长")
    private String isTeachingGroupLeader;

    /** 是否教研组长 */
    @Excel(name = "是否教研组长")
    private String isResearchGroupLeader;

    /** 设计课时 */
    @Excel(name = "设计课时")
    private Integer classHour;

    /** 班主任情况 */
    @Excel(name = "班主任情况")
    private String classTeacherDetails;

    /** 状态 */
    @Excel(name = "状态 (初始化为 1 编辑   老师个人提交 4已提交  级部确认过   5已确认  级部驳回     9驳回)" )
    private String state;

    private Long gradeTeacherId;

    private String userId;

    private String noticeName;


}
