package yangtz.cs.liu.campus.domain.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/*
* 老师履历表实体
* */
@Data
public class SchoolTeacherResume extends OurBaseEntity {
    private static final long serialVersionUID = 1L;


    /** 老师主键 */
    @Excel(name = "老师主键")
    @NotNull(message = "老师id不能为空")
    private Long teacherId;

    /** 履历开始时间 */
    @Excel(name = "履历开始时间")
    @NotNull(message = "履历开始时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date learnStart;

    /** 履历结束时间 */
    @Excel(name = "履历结束时间")
    @NotNull(message = "履历结束时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date learnEnd;

    /** 学校或者工作单位 */
    @Excel(name = "学校或者工作单位")
    @NotBlank(message = "学校或者工作单位不能为空")
    private String learnSchool;
    private String remark;
}
