package yangtz.cs.liu.campus.domain.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.NonNull;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class SchoolTeacherAward extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */

    @NotNull(message = "老师id不能为空")
    private Long teacherId;

    @Excel(name = "老师名称")
//    @NotBlank(message = "老师名称不能为空")
    private String teacherName;

    /**
     * 获奖时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "获奖时间不能为空")
    @Excel(name = "获奖时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date awardTime;

    /**
     * 获奖名称
     */
    @Excel(name = "获奖名称")
    @NotBlank(message = "获奖名称不能为空")
    private String awardName;

    private String remark;
    @Excel(name = "荣誉级别",readConverterExp = "0=校级,1=县区级,2市级,3=省级,4=国家级,5=其他")
    @NotBlank(message = "荣誉级别不能为空")
    private String honor;
//    @NotBlank(message = "荣誉证书图片不能为空")
    private String picUrl;


}
