package yangtz.cs.liu.campus.domain.student;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 学生嘉奖对象 school_student_award
 *
 * @author ruoyi
 * @date 2024-01-08
 */
@Data
public class SchoolStudentAward
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 学年 */
    @Excel(name = "学年")
    private String schoolYear;

    /** 学期 */
    @Excel(name = "学期",dictType = "semester_jsdzda")
    private String semester;

    /** 届别 */
    @Excel(name = "届别")
    private String year;

    /** 年级 */
    @Excel(name = "年级",dictType = "grade_da")
    private String grade;

    /** 班级 */
    @Excel(name = "班级")
    private String className;

    /** 班级类型 */
    @Excel(name = "班级类型")
    private String classType;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 性别 */
    @Excel(name = "性别",dictType = "sys_user_sex")
    private String sex;

    /** 班主任id */
    private Long classTeacherId;

    /** 班主任 */
    @Excel(name = "班主任")
    private String classTeacher;

    /** 级部主任id */
    private Long departmentDirectorId;

    /** 级部主任 */
    @Excel(name = "级部主任")
    private String departmentDirector;

    /** 嘉奖类别 */
    @Excel(name = "嘉奖类别")
    private String awardType;

    /** 嘉奖级别 */
    @Excel(name = "嘉奖级别",dictType = "student_award_rank")
    private String awardRank;

    /** 嘉奖时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "嘉奖时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date awardTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 审核状态 */
    @Excel(name = "审核状态", dictType = "audit_state")
    private String auditState;

    /** 创建人id */
    private Long createById;

    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 修改人id */
    private Long updateById;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 删除状态 */
    private String delFlag;
}
