package yangtz.cs.liu.campus.domain.schooloffical;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.joda.time.DateTime;

import java.util.Date;

@Data
public class SchoolOfficialFlow extends OurBaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private Long officialId;

    /**
     * 接收人id
     */
    private Long receiveUser;

    /**
     * 接收时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date receiveTime;

    /**
     * 接收人类型
     */
    private String receiveType;

    /**
     * 意见
     */
    private String opinion;

    /**
     * 状态
     */
    private String state;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date finishTime;
}
