package yangtz.cs.liu.campus.domain.schoolexam;

import java.util.Date;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class SchoolExam extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 班级id */
    private Long classId;

    /** 年级数值 */
    @Excel(name = "年级",readConverterExp = "1=一年级,2=二年级,3=三年级")
    private Integer gradeValue;

    /** 年级名称 */
    @NotNull(message = "年级名称不能为空")
    private String gradeName;

    /** 班级数值 */
    @Excel(name = "班级",readConverterExp = "1=一班,2=二班,3=三班,4=四班,5=五班,6=六班,7=七班,8=八班")
    private Integer classValue;

    /** 班级名称 */
    @NotNull(message = "班级名称不能为空")
    private String className;

    /** 班级别名 */
    @Excel(name = "班级别名")
    private String classAlias;

    /** 考试日期 */
    @NotNull(message = "考试日期不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "考试日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date examTime;

    /** 考试名称 */
    @NotBlank(message = "考试名称不能为空")
    @Excel(name = "考试名称")
    private String examName;

    @Excel(name = "学年")
    private Integer schoolYear;
}
