package yangtz.cs.liu.campus.domain.schoolStudio;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 录播室使用情况对象 school_studio_use
 *
 * @author ruoyi
 * @date 2023-07-10
 */
public class SchoolStudioUse extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 录播室使用情况主键id */
    private Long id;

    /** 预约id */
    @Excel(name = "预约id")
    private Long appointmentId;

    /** 录播室id */
    @Excel(name = "录播室id")
    private Long studioId;

    /** 录播室名称 */
    @Excel(name = "录播室名称")
    private String studioName;

    /** 使用日期 */
    @Excel(name = "使用日期", width = 30)
    private String useDate;

    /** 使用节次 */
    @Excel(name = "使用节次")
    private String useJc;

    /** 使用人id */
    @Excel(name = "使用人id")
    private Long useUserId;

    /** 使用人 */
    @Excel(name = "使用人")
    private String useUserName;

    /** 开始时间 */
    private String startTime;

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getAppointmentId() {
        return appointmentId;
    }
    public void setAppointmentId(Long appointmentId) {
        this.appointmentId = appointmentId;
    }

    public Long getId()
    {
        return id;
    }
    public void setStudioId(Long studioId)
    {
        this.studioId = studioId;
    }

    public Long getStudioId()
    {
        return studioId;
    }
    public void setStudioName(String studioName)
    {
        this.studioName = studioName;
    }

    public String getStudioName()
    {
        return studioName;
    }
    public void setUseDate(String useDate)
    {
        this.useDate = useDate;
    }

    public String getUseDate()
    {
        return useDate;
    }
    public void setUseJc(String useJc)
    {
        this.useJc = useJc;
    }

    public String getUseJc()
    {
        return useJc;
    }
    public void setUseUserId(Long useUserId)
    {
        this.useUserId = useUserId;
    }

    public Long getUseUserId()
    {
        return useUserId;
    }
    public void setUseUserName(String useUserName)
    {
        this.useUserName = useUserName;
    }

    public String getUseUserName()
    {
        return useUserName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("studioId", getStudioId())
                .append("studioName", getStudioName())
                .append("useDate", getUseDate())
                .append("useJc", getUseJc())
                .append("useUserId", getUseUserId())
                .append("useUserName", getUseUserName())
                .toString();
    }
}
