package yangtz.cs.liu.campus.domain.schoolRewardsPunishments;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

/**
 * 学生违纪对象 school_sc_discipline
 *
 * @author ruoyi
 * @date 2023-11-06
 */
@Data
public class SchoolScDiscipline extends OurBaseEntity
{
    /** 学年 */
    @Excel(name = "学年")
    private String schoolYear;

    /** 学期 */
    @Excel(name = "学期")
    private String semester;

    /** 届别 */
    @Excel(name = "届别")
    private String gradeYear;

    /** 年级id */
    @Excel(name = "年级id")
    private Long gradeId;

    /** 年级 */
    @Excel(name = "年级")
    private String gradeName;

    /** 班级id */
    @Excel(name = "班级id")
    private Long classId;

    /** 班级 */
    @Excel(name = "班级")
    private String className;

    /** 班级类型 */
    @Excel(name = "班级类型")
    private String classType;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 性别 */
    @Excel(name = "性别")
    private String sex;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 班主任id */
    private Long classTeacherId;

    /** 班主任 */
    @Excel(name = "班主任")
    private String classTeacher;

    /** 级部主任id */
    private Long gradeDirectorId;

    /** 级部主任 */
    @Excel(name = "级部主任")
    private String gradeDirector;

    /** 违纪行为 */
    @Excel(name = "违纪行为")
    private String violateType;

    /** 违纪次数（字典） */
    @Excel(name = "违纪次数", readConverterExp = "字=典")
    private String violateNum;

    /** 处分结果（字典） */
    @Excel(name = "处分结果", readConverterExp = "字=典")
    private String punishResult;

    /** 处分时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "处分时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date punishTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 审核状态(0未提交，1审核中，2通过，3驳回) */
    @Excel(name = "审核状态(0未提交，1审核中，2通过，3驳回)")
    private String auditState;

    /** 申请人id */
    private Long applyId;

    /** 申请人 */
    private String applyName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;
}
