package yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 团队获奖对象 school_xteam_award
 * 
 * @author ruoyi
 * @date 2023-12-13
 */
@Data
public class SchoolXteamAward extends BaseEntity
{

    /** 主键id */
    @TableId(value = "id",type = IdType.AUTO)
    private Long id;

    /** 学年 */
    @Excel(name = "学年",dictType = "yearda")
    private String schoolYear;

    /** 学期 */
    @Excel(name = "学期",dictType = "semester_jsdzda")
    private String semester;

    /** 届别 */
    @Excel(name = "届别",dictType = "rankda")
    private String year;

    /** 年级 */
    @Excel(name = "年级",dictType = "grade_da")
    private String grade;

    /** 学科 */
    @Excel(name = "学科",dictType = "teaching_subjects")
    private String sub;

    /** 获奖情况 */
    @Excel(name = "获奖情况")
    private String awardSituation;

    /** 团队成员贡献情况 */
    @Excel(name = "团队成员贡献情况")
    private String teamMembersContribution;

    /** 审核状态（0未提交，1审核中，2同意，3驳回） */
    @Excel(name = "审核状态", readConverterExp = "0=未提交，1审核中，2同意，3驳回")
    private String auditState;

    private String noAuditState;

    /** 删除状态 */
    private String delFlag;


}
