package yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;

/**
 * 教学成绩对象 school_xteaching_achievements
 *
 * @author ruoyi
 * @date 2023-12-06
 */
@Data
public class SchoolXteachingAchievements
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 学年(下拉框) */
//    @Excel(name = "学年",combo = {"2018-2019","2019-2020","2020-2021","2021-2022","2022-2023","2023-2024","2024-2025","2025-2026",
//            "2026-2027","2027-2028","2028-2029","2029-2030","2030-2031","2031-2032","2032-2033"})
    @Excel(name = "学年")
    private String schoolYear;

    /** 学期（下拉框） */
//    @Excel(name = "学期",combo = {"第一学期","第二学期"}, readConverterExp = "1=第一学期,2=第二学期")
    @Excel(name = "学期")
    private String semester;

    /** 考试时间（年月日） */
    @Excel(name = "考试时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date examTime;

    /** 考试类型（下拉框） */
//    @Excel(name = "考试类型",combo = {"月考","期中","期末","一模","二模","三模","高考","其它"},
//            readConverterExp = "1=月考,2=期中,3=期末,4=一模,5=二模,6=三模,7=高考,8=其它")
    @Excel(name = "考试类型")
    private String examType;

    /** 届别(下拉框) */
//    @Excel(name = "届别", combo = {"2018","2019","2020","2021","2022","2023","2024","2025","2026","2027","2028","2029","2030","2031","2032","2033"})
    @Excel(name = "届别")
    private String year;

    /** 年级（下拉框） */
//    @Excel(name = "年级", combo = {"高一","高二","高三"},readConverterExp = "1=高一,2=高二,3=高三")
    @Excel(name = "年级")
    private String grade;

    /** 用户id */
    private Long userId;

    /** 用户姓名 */
    @Excel(name = "姓名")
    private String userName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 学科 */
//    @Excel(name = "学科",combo = {"语文","数学","英语","物理","化学","生物","政治","历史","地理","音乐","体育","美术","技术","心理","书法"},
//            readConverterExp = "1=语文,2=数学,3=英语,4=物理,5=化学,6=生物,7=政治,8=历史,9=地理,10=音乐,11=体育,12=美术,13=技术,14=心理,15=书法")
    @Excel(name = "学科")
    private String sub;

    /** 班级 */
    @Excel(name = "班级")
    private String className;

    /** 班级类型 */
    @Excel(name = "班级类型")
    private String classType;

    /** 考核分 */
    @Excel(name = "考核分")
    private BigDecimal assessmentScore;

    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 备注 */
    private String remark;

    /** 删除状态 */
    private String delFlag;
}
