package yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;

/**
 * 综合荣誉对象 school_xcomprehensive_honors
 *
 * @author ruoyi
 * @date 2023-12-06
 */
@Data
public class SchoolXcomprehensiveHonors
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 学科（下拉框） */
    @Excel(name = "学科",combo = {"语文","数学","英语","物理","化学","生物","政治","历史","地理","音乐","体育","美术","技术","心理","书法"},
            readConverterExp = "1=语文,2=数学,3=英语,4=物理,5=化学,6=生物,7=政治,8=历史,9=地理,10=音乐,11=体育,12=美术,13=技术,14=心理,15=书法")
    private String sub;

    /** 获奖类别 */
    @Excel(name = "获奖类别")
    private String awardType;

    /** 获奖级别（下拉框） */
    @Excel(name = "获奖级别",combo = {"国家级","省部级","市级","县区级","校级","其他"},readConverterExp = "1=国家级,2=省部级,3=市级,4=县区级,5=校级,6=其他")
    private String awardRank;

    /** 获奖等级（下拉框） */
    @Excel(name = "获奖等级",combo = {"特等奖","一等奖","二等奖","三等奖","优秀奖","不设等级"},readConverterExp = "1=特等奖,2=一等奖,3=二等级,4=三等奖,5=优秀奖,6=不设等级")
    private String awardLevel;

    /** 成果名称 */
    @Excel(name = "成果名称")
    private String resultName;

    /** 获奖人id */
    private Long userId;

    /** 获奖人 */
    @Excel(name = "获奖者")
    private String userName;

    /** 主办单位 */
    @Excel(name = "主办单位")
    private String org;

    /** 获奖时间（年月日） */
    @Excel(name = "获奖时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date awardTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 证书图片名称 */
    private String pictureName;

    /** 证书图片地址 */
    private String pictureUrl;

    /** 审核状态（0未提交，1审核中，2通过，3驳回） */
    private String auditState;

    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 删除状态 */
    private String delFlag;
}
