package yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.NonNull;

import java.util.Date;

/**
 * 教师电子档案 老师基础信息
 */
@Data
public class SchoolTeacherBasicInformation extends BaseEntity {
//    @Excel(name = "年级",combo = {"一年级","二年级","三年级"},readConverterExp = "1=一年级,2=二年级,3=三年级")

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 姓名
     */
    @Excel(name = "姓名")
    private String name;

    /**
     * 身份证号
     */
    @Excel(name = "身份证号")
    private String idCard;

    /**
     * 年龄  。动态查询
     */
//    private Integer age;


    /**
     * 性别
     */
    private String sex;

    /**
     * 档案出生日期 (年月)
     */
    @Excel(name = "档案出生日期")
    @JsonFormat(pattern = "yyyy-MM")
    private Date fileBirthDate;


    /**
     * 档案年龄
     */
//    private Integer fileAge;


    /**
     * 出生年月
     */
    private String birthDate;

    /**
     * 籍贯
     */
    @Excel(name = "籍贯")
    private String hometown;

    /**
     * 民族
     */
    @Excel(name = "民族")
    private String nation;

    /**
     * 政治面貌(1中共党员、2共青团员、3群众、4民主党派成员、5无党派人士)
     */
    @Excel(name = "政治面貌")
    private String politicalLandscape;

    /**
     * 入党时间（年月）
     */
    @Excel(name = "入党时间")
    @JsonFormat(pattern = "yyyy-MM")
    private Date partyMembershipTime;

    /**
     * 任教学科(1语文、2数学、3英语、4物理、5化学、6生物、7政治、8历史、9地理、10音乐、11体育、12美术、13技术、14心理、15书法)
     */
    @Excel(name = "任教学科")
    private String teachingSubject;

    /**
     * 现职称(1无、2初级、3中级、4副高、5正高)
     */
    @Excel(name = "现职称")
    private String currentProfessionalTitle;

    /**
     * 现职称取得资格时间
     */
    @Excel(name = "现职称取得资格时间")
//    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date currentProfessionalTitleTime;

    /**
     * 现聘职称(1无、2初级、3中级、4副高、5正高)
     */
    @Excel(name = "现聘职称")
    private String currentHiringProfessionalTitle;

    /**
     * 现职称聘任时间
     */
    @Excel(name = "现职称聘任时间")
//    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date currentHiringProfessionalTitleTime;

    /**
     * 现聘岗位(1专业技术岗、2管理岗、3工勤岗)
     */
    @Excel(name = "现聘岗位")
    private String currentPosition;

    /**
     * 现岗位等级(见习（三个现聘岗位都有见习这个等级 下拉框联动）、专业技术三级-专业技术十三级、
     * 管理五级-管理九级、技术工二级-技术工五级)
     */
    @Excel(name = "现岗位等级")
    private String currentJobLevel;

    /**
     * 现岗位等级聘任时间
     */
    @Excel(name = "现岗位等级聘任时间")
//    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date currentJobLevelAppointmentTime;

    /**
     * 职务
     */
    @Excel(name = "职务")
    private String duties;

    /**
     * 教师资格种类
     */
    @Excel(name = "教师资格种类")
    private String teacherQualificationType;

    /**
     * 教师资格证号码
     */
    @Excel(name = "教师资格证号码")
    private String teacherQualificationCertificateNum;

    /**
     * 参加工作时间
     */
    @Excel(name = "参加工作时间")
    private String workingHours;

    /**
     * 到二中工作时间
     */
    @Excel(name = "到二中工作时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date toSecondMiddleSchoolTime;

    /**
     * 二中工作年龄 动态查询
     */
//    private Integer toSecondAge;

    /**
     * 教龄起算时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date lengthOfTeacherTime;

    /**
     * 工龄起算时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date lengthOfServiceTime;

    /**
     * 工龄年限
     */
//    private Integer seniority;

    /**
     * 在岗情况(1教学岗位、2教辅岗、3后勤岗、4管理岗、5其他岗、6退休、7行政、8内退岗、9待退岗)
     */
    @Excel(name = "在岗情况")
    private String onDutySituation;

    /**
     * 在编情况 1在编 2合同制
     */
    @Excel(name = "在编情况")
    private String currentSituation;

    /**
     * 毕业院校1
     */
    @Excel(name = "毕业院校1")
    private String graduationInstitution1;

    /**
     * 专业1
     */
    @Excel(name = "专业1")
    private String major1;

    /**
     * 毕业时间1 年月
     */
    @Excel(name = "毕业时间1")
    @JsonFormat(pattern = "yyyy-MM")
    private Date graduationTime1;

    /**
     * 毕业院校2
     */
    @Excel(name = "毕业院校2")
    private String graduationInstitution2;

    /**
     * 专业2
     */
    @Excel(name = "专业2")
    private String major2;

    /**
     * 毕业时间2年月
     */
    @Excel(name = "毕业时间2")
    @JsonFormat(pattern = "yyyy-MM")
     private Date graduationTime2;

    /**
     * 毕业院校3
     */
    @Excel(name = "毕业院校3")
    private String graduationInstitution3;

    /**
     * 专业3
     */
    @Excel(name = "专业3")
    private String major3;

    /**
     * 毕业时间3 年月
     */
    @Excel(name = "毕业时间3")
    @JsonFormat(pattern = "yyyy-MM")
    private Date graduationTime3;

    /**
     * 第一学历
     */
    @Excel(name = "第一学历")
    private String firstDegree;

    /**
     * 最后学历
     */
    private String lastDegree;

    /**
     *  学位
     */
    @Excel(name = "学位")
    private String degree;

    /**
     * 工作经历
     */
    @Excel(name = "工作经历")
    private String  workExperience;

    /**
     * 照片名称
     */
    private String photoName;

    /**
     * 照片地址
     */
    private String photoUrl;

    /**
     * 钉钉手机号
     */
    @Excel(name = "钉钉手机号")
    private String ddPhone;

    /**
     * 备注
     */
    @Excel(name = "备注")
    private String remark;
//
//    /**
//     *  出生日期临时查询参数
//     */
//    private String birthDategt;
//    private String birthDategtd;
//    private String birthDatelt;
//    private String birthDateltd;
//
//    /**
//     *  参加工作临时查询参数
//     */
//    private String workingHoursgt;
//    private String workingHoursgtd;
//    private String workingHourslt;
//    private String workingHoursltd;
}
