package yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 高考成绩对象 school_gk_achievement
 * 
 * @author ruoyi
 * @date 2023-12-13
 */
@Data
public class SchoolGkAchievement extends BaseEntity
{

    /** 主键id */
    @TableId(value = "id",type = IdType.AUTO)
    @Excel(name = "序号")
    private Long id;
    /** 届别 */
    @Excel(name = "届别",dictType = "rankda")
    private String year;

    /** 学科(下拉框) */
    @Excel(name = "学科" ,dictType = "teaching_subjects")
    private String sub;

    /** 教师姓名 */
    @Excel(name = "教师姓名")
    private String teacherName;

    /**老师id**/
    private Long userId;

    /** 授课班级 */
    @Excel(name = "授课班级",dictType = "class_num")
    private String teachingClassName;

    /** 班级类型(下拉框) */
    @Excel(name = "班级类型",dictType = "class_type")
    private String classType;

    /** 高考评优(下拉框) */
    @Excel(name = "高考评优",dictType = "gk_appraising")
    private String gkAppraising;

    /** 尖子生培养 */
    @Excel(name = "尖子生培养")
    private String topStudentsCulture;

    /** 增量情况 */
    @Excel(name = "增量情况")
    private String incrementSituation;

    /** 有效数情况 */
    @Excel(name = "有效数情况")
    private String effectiveNumSituation;

    /** 其他 */
    @Excel(name = "其他情况")
    private String other;

    /** 审核状态（0未提交，1审核中，2同意，3驳回） */
    private String auditState;
    private String noAuditState;

    /** 删除状态 */
    private String delFlag;

}
