package yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn;

import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 工作量信息对象 school_aworkload
 *
 * @author ruoyi
 * @date 2023-12-11
 */
@Data
public class SchoolAworkloadExport extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 学年(下拉框) */
    @Excel(name = "学年")
    private String schoolYear;

    /** 学期(下拉框) */
    @Excel(name = "学期")
    private String semester;

    /** 届别(下拉框) */
    @Excel(name = "届别")
    private String year;

    /** 年级(下拉框) */
    @Excel(name = "年级")
    private String grade;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 学科(下拉框) */
    @Excel(name = "学科")
    private String sub;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 聘任岗位(下拉框) */
    @Excel(name = "聘任岗位")
    private String appointmentPost;

    /** 聘任职务 */
    @Excel(name = "聘任职务")
    private String appointmentPosition;

    /** 聘任情况(下拉框) */
    @Excel(name = "聘任情况")
    private String appointmentSituation;

    /** 班级 */
    @Excel(name = "班级",prompt="多个，中间用英文“,”间隔")
    private String className;

    /** 班级类型 */
    @Excel(name = "班级类型")
    private String classType;

    /** 早读 */
//    @Excel(name = "早读")
    private BigDecimal earlyReading;

    /** 正课 */
//    @Excel(name = "正课")
    private BigDecimal requiredCourses;

    /** 晚自习 */
//    @Excel(name = "晚自习")
    private BigDecimal eveningSelfStudy;

    /**合计*/
//    @Excel(name = "合计")
    private BigDecimal amountTo;

    /** 周课时量 */
    @Excel(name = "周课时量")
    private BigDecimal weeklyClassHours;

    /** 证明人id */
    private Long userId;

    /** 证明人 */
    @Excel(name = "证明人")
    private String userName;

    @Excel(name = "备注")
    private String remark;

    /** 删除状态 */
    private String delFlag;


}
