package yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class SchoolAclassTeacherAssessmentExport extends BaseEntity
{

    /** 主键id */
    @TableId(value = "id",type = IdType.AUTO)
    private Long id;

    /** 学期(下拉框) */
    @Excel(name = "学期",combo = {"第一学期","第二学期"},readConverterExp = "1=第一学期,2=第二学期")
    private String semester;

    /** 届别(下拉框) */
    @Excel(name = "届别")
    private String year;

    /** 学年(下拉框) */
    @Excel(name = "学年")
    private String schoolYear;

    /** 年级(下拉框) */
    @Excel(name = "年级",combo = {"高一","高二","高三"},readConverterExp = "1=高一,2=高二,3=高三")
    private String grade;

    /** 班级(下拉框) */
    @Excel(name = "班级",readConverterExp="1=1,2=2,3=3,4=4,5=5,6=6,7=7,8=8,9=9,10=10,11=11,12=12,13=13,14=14,15=15,16=16,17=17,18=18,19=19,20=20,21=21,22=22,23=23,24=24,25=25,26=26,27=27,28=28,29=29,30=30,31=31,32=32,33=33,34=34,35=35,36=36,37=37,38=38,39=39,40=40")
    private String className;

    /** 教师姓名 */
    @Excel(name = "教师姓名")
    private String teacherName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 德育考核成绩 */
    @Excel(name = "德育考核成绩")
    private BigDecimal moralEduCheckAchievement;

    /** 智育考核成绩 */
    @Excel(name = "智育考核成绩")
    private BigDecimal intellEduCheckAchievement;

    /** 总考核成绩 */
    @Excel(name = "总考核成绩")
    private BigDecimal totalCheckAchievement;

    /** 班级类型(下拉框) */
    @Excel(name = "班级类型")
    private String classType;

    /** 学科(下拉框) */
    @Excel(name = "学科",dictType = "sub_dzdn")
    private String sub;

    /** 考核结果 */
    @Excel(name = "考核结果",dictType = "assessment_results")
    private String assessmentResults;

    /** 备注*/
    @Excel(name = "备注")
    private String remark;


    /** 删除状态 */
    private String delFlag;
}
