package yangtz.cs.liu.campus.domain.schoolLab;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;

/**
 * 教师实验室申请对象 school_teacher_lab_apply
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Data
public class SchoolTeacherLabApply extends OurBaseEntity
{

    /** 年级实验室预约主键id */
    @Excel(name = "年级实验室预约主键id")
    private String labClassYearId;

    /** 实验分类（1分组实验，2演示实验，3探究实验） */
    @Excel(name = "实验分类", readConverterExp = "1=分组实验,2=演示实验,3=探究实验")
    private String experimentClassify;

    /** 实验计划id */
    private Long experimentPlanId;

    /** 实验名称 */
    private String experimentName;

    /** 学科（1物理，2化学，3生物） */
    @Excel(name = "学科", readConverterExp = "1=物理,2=化学,3=生物")
    private String sub;

    /** 级部id */
    private Long gradeId;

    /** 级部 */
    @Excel(name = "级部")
    private String grade;

    /** 学年 */
    @Excel(name = "学年")
    private String schoolYear;

    /** 学期（1上学期，2下学期） */
    @Excel(name = "学期", readConverterExp = "1=上学期,2=下学期")
    private String semester;

    /** 班级id */
    @Excel(name = "班级id")
    private String classId;

    /** 班级名称 */
    @Excel(name = "班级名称")
    private String className;

    /** 章节内容 */
    @Excel(name = "章节内容")
    private String chapterContent;

    /** 实验时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "实验时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date experimentTime;

    /** 节次 */
    @Excel(name = "节次")
    private String section;

    /** 实验室id */
    @Excel(name = "实验室id")
    private Long labId;

    /** 实验室名称 */
    @Excel(name = "实验室名称")
    private String labName;

    /** 申请状态（1已确认，0未确认） */
    @Excel(name = "申请状态", readConverterExp = "1=已确认,0=未确认")
    private String applyState;

    /** 申请人id */
    @Excel(name = "申请人id")
    private Long applyId;

    /** 申请人 */
    @Excel(name = "申请人")
    private String applyName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /** 实验室是否使用完成 （0未完成，1完成） */
    private String state;
}
