package yangtz.cs.liu.campus.domain.schoolLab;

import java.util.List;
import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;

/**
 * 年级实验室预约对象 school_lab_class_year
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Data
public class SchoolLabClassYear extends OurBaseEntity
{

    /** 实验计划id */
    private Long experimentPlanId;

    /** 实验名称 */
    private String experimentName;

    /** 级部id */
    private Long gradeId;

    /** 级部 */
    @Excel(name = "级部")
    private String grade;

    /** 学年 */
    @Excel(name = "学年")
    private String schoolYear;

    /** 学期（1上学期，2下学期） */
    @Excel(name = "学期", readConverterExp = "1=上学期,2=下学期")
    private String semester;

    /** 学科（1物理，2化学，3生物） */
    @Excel(name = "学科", readConverterExp = "1=物理,2=化学,3=生物")
    private String sub;

    /** 实验分类（1分组实验，2演示实验，3探究实验） */
    @Excel(name = "实验分类", readConverterExp = "1=分组实验,2=演示实验,3=探究实验")
    private String experimentClassify;

    /** 计划开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "计划开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date plannedStartTime;

    /** 计划结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "计划结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date plannedEndTime;

    /** 章节内容 */
    @Excel(name = "章节内容")
    private String chapterContent;

    /** 实验用品 */
    @Excel(name = "实验用品")
    private String experimentUseGoods;

    /** 申报状态（0未申报，1已申报，2已阅读，3已分配） */
    @Excel(name = "申报状态", readConverterExp = "0=未申报,1=已申报,2=已阅读,3=已分配")
    private String declareState;

    /** 申报人id */
    @Excel(name = "申报人id")
    private Long applyId;

    /** 申报人 */
    @Excel(name = "申报人")
    private String applyName;

    /** 申报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申报时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /** 年级实验室预约和实验室关系信息 */
    private List<SchoolLabClassYearRelation> schoolLabClassYearRelationList;
}
