package yangtz.cs.liu.campus.domain.schoolDuty;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;


/**
 * 值班管理明细对象 school_duty_details
 *
 */
@Data
public class SchoolDutyDetails extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 值班id */
    /*@Excel(name = "值班id")*/
    private Long dutyId;

    /** 日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date dutyDeDate;

    /** 星期 */
    @Excel(name = "星期")
    private String dutyDeWeek;

    /** 类型(0带班领导 1值班人员 2行政值班 3办公室值班 4门卫值班 5宿舍值班) */
    @Excel(name = "类型", readConverterExp = "0=带班领导,1=值班人员,2=行政值班,3=办公室值班,4=门卫值班,5=宿舍值班")
    private String dutyDeType;

    /** 值班人 */
    /*@Excel(name = "值班人")*/
    private Long dutyDeUser;

    /** 值班人姓名 */
    @Excel(name = "值班人姓名")
    private String dutyDeUsername;

    /** 值班人手机 */
    @Excel(name = "值班人手机")
    private String dutyDePhone;

    /** 值班人电话 */
    @Excel(name = "值班人电话")
    private String dutyDeTel;

    /** 说明 */
    @Excel(name = "说明")
    private String remarks;

}
